/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.finmgmt.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.finmgmt.dao.EbmktPackageDao;
import com.ebike.openservices.finmgmt.entity.EbmktCmpnPachageVo;
import com.ebike.openservices.finmgmt.service.EbmktPackageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EbmktPackageServiceImpl
implements EbmktPackageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EbmktPackageDao packageDao;

    @Autowired
    public EbmktPackageServiceImpl(EbmktPackageDao packageDao) {
        this.packageDao = packageDao;
    }

    public List<EbmktCmpnPachageVo> getPackageInfo(Map<String, Object> map) {
        return this.packageDao.getPackageInfo(map);
    }

    public int getPackageInfoCount(Map<String, Object> map) {
        return this.packageDao.getPackageInfoCount(map);
    }

    public List<EbmktCmpnPachageVo> getRelationStationInfo(Map<String, Object> map, Pager pager) {
        return this.packageDao.getRelationStationInfo(map, pager);
    }

    public int getStationInfoCount(Map<String, Object> map) {
        return this.packageDao.getStationInfoCount(map);
    }

    public int insertEbmktPackage(EbmktCmpnPachageVo pachageVo) {
        int result = this.packageDao.insertEbmktPackage(pachageVo);
        int result1 = this.packageDao.insertEbmktCmpn(pachageVo);
        int result3 = this.packageDao.insertLogInfo(pachageVo);
        ArrayList<EbmktCmpnPachageVo> list = new ArrayList<EbmktCmpnPachageVo>();
        String[] stationId = pachageVo.getStationIds().split(",");
        for (int i = 0; i < stationId.length; ++i) {
            EbmktCmpnPachageVo pachageVo1 = new EbmktCmpnPachageVo();
            pachageVo1.setStationIds(stationId[i]);
            pachageVo1.setCmpnId(pachageVo.getCmpnId());
            pachageVo1.setCreateTime(DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            list.add(pachageVo1);
        }
        int result2 = this.packageDao.insertEbmktCmpnRel(list);
        if (result > 0 && result1 > 0 && result2 > 0 && result3 > 0) {
            return result + result1 + result2;
        }
        return 0;
    }

    public int checkPackageExist(Map<String, Object> map) {
        return this.packageDao.checkPackageExist(map);
    }

    public int updatePackage(Map<String, Object> map) {
        String[] cmpnIds = map.get("logCmpnIds").toString().split(",");
        for (int i = 0; i < cmpnIds.length; ++i) {
            EbmktCmpnPachageVo pachageVo = new EbmktCmpnPachageVo();
            pachageVo.setLogOperator(map.get("orgName").toString());
            pachageVo.setLogType(map.get("cmpnStatus").toString());
            pachageVo.setLogValue(map.get("logValue").toString());
            pachageVo.setLogTime(new Date());
            pachageVo.setCmpnId(cmpnIds[i]);
            int n = this.packageDao.insertLogInfo(pachageVo);
        }
        return this.packageDao.updatePackage(map);
    }

    public EbmktCmpnPachageVo getPackageInfoById(String cmpnId) {
        return this.packageDao.getPackageInfoById(cmpnId);
    }

    public int updateEbmktPackage(EbmktCmpnPachageVo pachageVo) {
        int result = this.packageDao.updateEbmktPackage(pachageVo);
        int result1 = this.packageDao.updateEbmktCmpn(pachageVo);
        int result3 = this.packageDao.insertLogInfo(pachageVo);
        ArrayList<EbmktCmpnPachageVo> list = new ArrayList<EbmktCmpnPachageVo>();
        String[] stationId = pachageVo.getStationIds().split(",");
        int result2 = this.packageDao.deletEbmktCmpnRel(pachageVo.getCmpnId());
        for (int i = 0; i < stationId.length; ++i) {
            EbmktCmpnPachageVo pachageVo1 = new EbmktCmpnPachageVo();
            pachageVo1.setStationIds(stationId[i]);
            pachageVo1.setCmpnId(pachageVo.getCmpnId());
            pachageVo1.setCreateTime(DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            list.add(pachageVo1);
        }
        int result4 = this.packageDao.insertEbmktCmpnRel(list);
        this.logger.debug("result4 " + result4);
        this.logger.debug("result " + result);
        this.logger.debug("result1 " + result1);
        this.logger.debug("result3 " + result3);
        return result + result1 + result4;
    }

    public List<Map<String, Object>> getPackageUsage(Map<String, Object> map, Sorter var2, Pager var3) {
        return this.packageDao.getPackageUsage(map, var2, var3);
    }

    public int getPackageUsageCount(Map<String, Object> map) {
        return this.packageDao.getCount(map);
    }

    public List<Map<String, Object>> getPackageAccountJournalByUserId(Map<String, Object> map) {
        return this.packageDao.getPackageAccountJournalByUserId(map);
    }

    public List<Map<String, String>> getRelationStationInfoByCmpnId(String cmpnId) {
        return this.packageDao.getRelationStationInfoByCmpnId(cmpnId);
    }

    public int getPackageAccountJournalCountByUserId(Map<String, Object> map) {
        return this.packageDao.getPackageAccountJournalCountByUserId(map);
    }

    public int getRelationStationCountByCmpnId(String cmpnId) {
        return this.packageDao.getRelationStationCountByCmpnId(cmpnId);
    }

    public List<EbmktCmpnPachageVo> getPackageAuditInfo(Map<String, Object> map) {
        return this.packageDao.getPackageAuditInfo(map);
    }

    public int getPackageAuditCountInfo(Map<String, Object> map) {
        return this.packageDao.getPackageAuditCountInfo(map);
    }

    public int packageAudit(Map<String, Object> map) {
        String[] cmpnIds = map.get("logCmpnIds").toString().split(",");
        for (int i = 0; i < cmpnIds.length; ++i) {
            EbmktCmpnPachageVo pachageVo = new EbmktCmpnPachageVo();
            pachageVo.setLogOperator(map.get("orgName").toString());
            pachageVo.setLogType(map.get("cmpnStatus").toString());
            pachageVo.setLogValue(map.get("logValue").toString());
            pachageVo.setLogTime(new Date());
            pachageVo.setCmpnId(cmpnIds[i]);
            int n = this.packageDao.insertLogInfo(pachageVo);
        }
        return this.packageDao.packageAudit(map);
    }
}

