/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.finmgmt.service.impl;

import com.ebike.openservices.finmgmt.entity.MjyddzbdParams;
import com.ebike.openservices.finmgmt.entity.MjyddzcxParams;
import com.ebike.openservices.finmgmt.jdbcdao.MjyddzglDao;
import com.ebike.openservices.finmgmt.service.MjyddzglService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mjyddzglService")
public class MjyddzglServiceImpl
implements MjyddzglService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="mjyddzglDao")
    private MjyddzglDao mjyddzglDao;

    public List<?> getApplyBindconsList(MjyddzcxParams params) {
        return this.mjyddzglDao.getApplyBindconsList(params);
    }

    public Map<?, ?> getApplyBindconsGrid(MjyddzcxParams params) {
        this.logger.info("getApplyBindconsGrid : " + params.toString());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("total", this.mjyddzglDao.getApplyBindconsCount(params));
        resultMap.put("results", this.mjyddzglDao.getApplyBindconsList(params));
        return resultMap;
    }

    public List<?> getConsBindingList(MjyddzcxParams params) {
        return this.mjyddzglDao.getConsBindingList(params);
    }

    public Map<?, ?> getConsBindingGrid(MjyddzcxParams params) {
        this.logger.info("getConsUnbindingGrid : " + params.toString());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("total", this.mjyddzglDao.getConsBindingCount(params));
        resultMap.put("results", this.mjyddzglDao.getConsBindingList(params));
        return resultMap;
    }

    public Map<String, Object> checkPassCondition(String applyId) {
        Integer cnt = this.mjyddzglDao.getHasBindConsCount(applyId);
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (cnt > 0) {
            res.put("status", 1);
            res.put("msg", "\u8be5\u7ed1\u5b9a\u7533\u8bf7\u4e2d\u6709\u7528\u7535\u5730\u5740\u5df2\u88ab\u5176\u4ed6\u4e70\u5bb6\u7ed1\u5b9a\uff0c\u65e0\u6cd5\u518d\u6b21\u8fdb\u884c\u7ed1\u5b9a\u3002");
        } else {
            res.put("status", 0);
            res.put("msg", "\u8be5\u7ed1\u5b9a\u7533\u8bf7\u4e2d\u7684\u7528\u7535\u5730\u5740\u6ca1\u6709\u88ab\u5176\u4ed6\u4e70\u5bb6\u7ed1\u5b9a\u8fc7\uff0c\u53ef\u8fdb\u884c\u7ed1\u5b9a\u3002");
        }
        return res;
    }

    public Map<String, Object> commitCheckBindApplication(MjyddzbdParams params) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (StringUtils.equals((CharSequence)params.getCheckResult(), (CharSequence)"01")) {
            Integer ubaResult;
            Integer icbResult;
            res.put("status", -1);
            res.put("msg", "\u63d0\u4ea4\u5ba1\u6838\u901a\u8fc7\u5931\u8d25");
            if (StringUtils.isNotBlank((CharSequence)params.getChecker()) && (icbResult = this.mjyddzglDao.insertConsBinding(params)) > 0 && (ubaResult = this.mjyddzglDao.updateBindApplication(params)) > 0) {
                res.put("status", 1);
                res.put("msg", "\u63d0\u4ea4\u5ba1\u6838\u901a\u8fc7\u6210\u529f");
            }
        }
        if (StringUtils.equals((CharSequence)params.getCheckResult(), (CharSequence)"02")) {
            Integer ubaResult;
            res.put("status", -1);
            res.put("msg", "\u63d0\u4ea4\u5ba1\u6838\u4e0d\u901a\u8fc7\u5931\u8d25");
            if (StringUtils.isNotBlank((CharSequence)params.getChecker()) && (ubaResult = this.mjyddzglDao.updateBindApplication(params)) > 0) {
                res.put("status", 1);
                res.put("msg", "\u63d0\u4ea4\u5ba1\u6838\u4e0d\u901a\u8fc7\u6210\u529f");
            }
        }
        return res;
    }

    public Map<String, Object> commitConsUnbingding(Long consId, String unbinder) {
        Integer dcbResult;
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("status", -1);
        res.put("msg", "\u89e3\u7ed1\u5931\u8d25");
        if (StringUtils.isNotBlank((CharSequence)unbinder) && (dcbResult = this.mjyddzglDao.deleteConsBinding(consId, unbinder)) > 0) {
            res.put("status", 1);
            res.put("msg", "\u89e3\u7ed1\u6210\u529f");
        }
        return res;
    }
}

