package com.ebike.openservices.oprmgmt.dto;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.commons.lang3.ObjectUtils;

import java.io.IOException;
import java.math.BigDecimal;

/**
 * BigDecimal序列化
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/13
 */
public class Decimal2Serializer extends JsonSerializer<BigDecimal> {

    @Override
    public void serialize(BigDecimal value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (ObjectUtils.isNotEmpty(value)) {
            //格式化两位小数，再去掉无用0
            BigDecimal bigDecimal = value.setScale(2, BigDecimal.ROUND_HALF_UP).stripTrailingZeros();
            gen.writeNumber(bigDecimal);
        }
    }
}
