package com.ebike.openservices.oprmgmt.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Collection;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/13
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PageResponse<T> implements Serializable {

    private static final long serialVersionUID = -1428966977071846212L;

    /**
     * 数据
     */
    private Collection<T> records;

    /**
     * 当前页
     */
    private int pageNumber;

    /**
     * 每页记录数
     */
    private int pageSize;

    /**
     * 总记录数
     */
    private long total;

    /**
     * 响应成功
     * @return
     */
    public static <T> PageResponse<T> of(Collection<T> data, int pageNumber, int pageSize, long total) {
        return new PageResponse<T>(data, pageNumber, pageSize, total);
    }
}
