package com.ebike.openservices.oprmgmt.dto;

import com.ebike.openservices.oprmgmt.enums.ErrorCodeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/13
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class Response<T> implements Serializable {

    private static final long serialVersionUID = 9051966969490803705L;

    /**
     * 状态码
     */
    private int code;

    /**
     * 信息
     */
    private String msg;

    /**
     * 数据
     */
    private T data;

    /**
     * 响应成功
     * @return
     */
    public static Response buildSuccess() {
        return buildSuccess(null);
    }

    public static <T> Response<T> buildSuccess(T data) {
        return new Response<T>().setCode(200).setMsg("请求成功").setData(data);
    }

    public static Response buildSuccess(int code, String msg) {
        return new Response().setCode(code).setMsg(msg);
    }

    /**
     * 响应失败
     * @return
     */
    public static Response buildFailure() {
        return new Response().setCode(ErrorCodeEnum.ERROR.getCode()).setMsg(ErrorCodeEnum.ERROR.getMsg());
    }

    public static Response buildFailure(int code, String msg) {
        return new Response().setCode(code).setMsg(msg);
    }

}
