package com.ebike.openservices.oprmgmt.entity;

import com.fasterxml.jackson.databind.util.JSONPObject;
import lombok.Data;

import java.io.Serializable;

/**
 * @author liumu
 * @date 2021/4/16 16:54
 * 汽车充电桩-运营商审核
 */
@Data
public class CarRegisterExamineVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 运营商注册标识
     */
    private String orgoprRegId;

    /**
     * 运营商编号
     */
    private String orgoprNo;

    /**
     * 管理单位;同一级业务单位编号primary_org_no
     */
    private String buro;

    /**
     * 维护单位;同业务单位编号org_no
     */
    private String subburo;

    /**
     * 运营商类型;10 – 公司；
     * 20 – 个人；
     */
    private String orgoprType;

    /**
     * 运营商名称;企业名称或个人姓名
     */
    private String orgoprName;

    /**
     * 运营商证件号码;统一社会信用代码或个人身份证
     */
    private String orgoprCredNo;

    /**
     * 运营商证件附件;阿里云OSS文件名，多个文件用分隔符;分开
     */
    private String orgoprCredAttach;


    /**
     * 微信支付是否直接到账;Y - 是；
     * N - 否；
     */
    private String wxpayDirectFlag;

    /**
     * 微信支付分账模式;0 - 不分账；
     * 1 - 普通商户分账模式；
     * 2 - 服务商分账模式；
     * 10 - 企业付款到零钱（由平台方微信商户账号付款给运营商微信零钱，目前只支持个人类型的运营商）；
     * 11 - 企业付款至银行卡（由平台方微信商户账号付款给运营商银行卡，目前只支持个人类型的运营商）；
     */
    private String wxpaySharingMode;

    /**
     * 微信账号类型;1 - 微信商户；
     * 2 - 微信个人；
     */
    private String wxAccountType;

    /**
     * 微信个人信息
     */
    private String wxPersonalInfo;

    /**
     * 是否是“微信特约商户”
     */
    private String isWx;

    /**
     * openId
     */
    private String openId;

    /**
     * openId对应名称
     */
    private String openIdName;

    /**
     * 审核结果：
     * W – 等待审核；
     * S – 审核通过；
     * F – 审核不通过；
     */
    private String verifyResult;

    /**
     * 审核说明
     */
    private String explain;

    /**
     * 审核人
     */
    private String verifier;

    /**
     * 服务费率
     */
    private String serviceRate;

    /**
     * 注册时间
     */
    private String regTime;

    /**
     * 生效时间
     */
    private String effTime;

}
