package com.ebike.openservices.oprmgmt.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author liumu
 * @date 2021-07-15 16:25
 * 充电卡账户提现申请 实体类
 */
@Data
public class CardAcctWithdrawApplyEntity implements Serializable {

    private static final long serialVersionUID = 654511213546543L;

    /**
     * 主键标识;SnowflakeId
     */
    private Long id;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 充电卡标识
     */
    private String cardId;

    /**
     * 提现账户类型;BANK – 银行卡；
     OFFLINE – 线下；
     ALIPAY – 支付宝（留用）；
     WXPAY – 微信（留用）；
     */
    private String wdAccountType;

    /**
     * 提现账户号
     */
    private String wdAccountNo;

    /**
     * 提现金额
     */
    private BigDecimal wdMoney;

    /**
     * 提现前账户余额
     */
    private BigDecimal wdBeforeBalance;

    /**
     * 提现说明
     */
    private String wdDesc;

    /**
     * 银行联行号
     */
    private String bankBranchLinkNo;

    /**
     * 提现订单标识
     */
    private String withdrawOrderId;

    /**
     * 申请人手机号码
     */
    private String applicantMobile;

    /**
     * 申请说明
     */
    private String applyDesc;

    /**
     * 审核人;系统用户表用户编号字段（user_no）
     */
    private String auditor;

    /**
     * 审核状态;0 - 待审核；1 - 审核通过；2 - 审核不通过；
     */
    private Integer auditStatus;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 审核说明
     */
    private String auditDesc;

    /**
     * 归档人
     */
    private String archiver;

    /**
     * 归档时间
     */
    private Date archiveTime;

    /**
     * 归档说明
     */
    private String archiveDesc;

    /**
     * 归档附件;阿里云OSS文件名，多个文件用分隔符;分开
     */
    private String archiveAttach;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;
}
