package com.ebike.openservices.oprmgmt.entity.po;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 电动汽车充电桩
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class DevEvChargingPile implements Serializable {

    private static final long serialVersionUID = 8337355693392936197L;

    /**
     * 主键标识;SnowflakeId
     */
    private Long id;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 充电站标识
     */
    private Long chargingStationId;

    /**
     * 充电桩编号
     */
    private String chargingPileNo;

    /**
     * 充电桩名称
     */
    private String chargingPileName;

    /**
     * 充电桩说明
     */
    private String chargingPileDesc;

    /**
     * 充电桩状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；5 - 故障；9 - 退运；
     */
    private Integer chargingPileStatus;

    /**
     * 充电桩类型;10 - 交流充电桩；21 - 直流充电桩（T）；22 - 直流充电桩（S）；
     */
    private Integer chargingPileType;

    /**
     * 充电桩通讯地址
     */
    private String chargingPileCommAddr;

    /**
     * 充电桩通讯参数
     */
    private String chargingPileCommParam;

    /**
     * 是否加密
     */
    private Boolean isEncrypt;

    /**
     * 加密方式
     */
    private String encryptType;

    /**
     * 加密信息
     */
    private String encryptInfo;

    /**
     * 硬件版本
     */
    private String hardwareVersion;

    /**
     * 软件版本
     */
    private String softwareVersion;

    /**
     * 生产厂家;编码HEPGMS_IOT_DEVICE_MFR_CODE
     */
    private String mfrCode;

    /**
     * 生产批次
     */
    private String prodBatch;

    /**
     * 生产日期
     */
    private Date prodDate;

    /**
     * 设备型号;编码HEPGMS_IOT_DEVICE_MODEL_CODE
     */
    private String modelCode;

    /**
     * 额定输入电压;单位：V
     */
    private BigDecimal ratedInputVoltage;

    /**
     * 额定输出电流;单位：A
     */
    private BigDecimal ratedOutputCurrent;

    /**
     * 最大输出功率;单位：kW
     */
    private BigDecimal maxOutputPower;

    /**
     * 物联卡MSISDN号
     */
    private String msisdn;

    /**
     * 物联卡ICCID号
     */
    private String iccid;

    /**
     * 充电枪数量;最大充电枪数量99
     */
    private Integer chargingGunCount;

    /**
     * 投运人
     */
    private String gotorunner;

    /**
     * 投运日期
     */
    private Date gotorunDate;

    /**
     * 投运备注
     */
    private String gotorunRemark;

    /**
     * 暂停人
     */
    private String pauser;

    /**
     * 暂停日期
     */
    private Date pauseDate;

    /**
     * 暂停备注
     */
    private String pauseRemark;

    /**
     * 退运人
     */
    private String stoprunner;

    /**
     * 退运日期
     */
    private String stoprunDate;

    /**
     * 退运备注
     */
    private String stoprunRemark;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;

}
