package com.ebike.openservices.oprmgmt.entity.po;

import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 电动汽车充电站
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
@Data
@ToString(callSuper = true)
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OperEvChargingStation implements Serializable {

    private static final long serialVersionUID = 4034016888501228035L;

    /**
     * 主键标识;SnowflakeId
     */
    private Long id;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 充电站编号
     */
    private String chargingStationNo;

    /**
     * 充电站名称
     */
    private String chargingStationName;

    /**
     * 充电站说明
     */
    private String chargingStationDesc;

    /**
     * 充电站状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；9 - 退运；
     */
    private Integer chargingStationStatus;

    /**
     * 充电站类型;1 - 公共；2 - 个人；11 - 公交（专用）；12 - 环卫（专用）；13 - 物流（专用）；14 - 出租车（专用）；99 - 其他；
     */
    private Integer chargingStationType;

    /**
     * 充电站地址
     */
    private String chargingStationAddr;

    /**
     * 最大输出功率;单位：kW
     */
    private BigDecimal maxOutputPower;

    /**
     * 配电总容量;单位：kVA
     */
    private BigDecimal totalDistCapacity;

    /**
     * 联系人
     */
    private String contacter;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 邮政编码
     */
    private String contactPostcode;

    /**
     * 联系地址
     */
    private String contactAddress;

    /**
     * 电子邮箱
     */
    private String contactEmail;

    /**
     * 手机号码
     */
    private String contactMobile;

    /**
     * 传真号码
     */
    private String contactFax;

    /**
     * 营业时间说明
     */
    private String businessHoursDesc;

    /**
     * 营业开始时间
     */
    private String businessHoursStart;

    /**
     * 营业结束时间
     */
    private String businessHoursEnd;

    /**
     * 停车收费说明
     */
    private String parkingFeeDesc;

    /**
     * 停车收费单价;单位：元 / 小时；
     */
    private BigDecimal parkingUnitPrice;

    /**
     * 是否支持预约充电
     */
    private Boolean isSupportAppt;
    /**
     * 预约信息
     */
    private Object  appInfo;

    /**
     * 行政区划代码
     */
    private String adcode;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 纬度
     */
    private BigDecimal latitude;

    /**
     * 投运人
     */
    private String gotorunner;

    /**
     * 投运日期
     */
    private Date gotorunDate;

    /**
     * 投运备注
     */
    private String gotorunRemark;

    /**
     * 暂停人
     */
    private String pauser;

    /**
     * 暂停日期
     */
    private Date pauseDate;

    /**
     * 暂停备注
     */
    private String pauseRemark;

    /**
     * 退运人
     */
    private String stoprunner;

    /**
     * 退运日期
     */
    private Date stoprunDate;

    /**
     * 退运备注
     */
    private String stoprunRemark;

//    public OperEvChargingStation field() {
//        return this.defaultField(this);
//    }

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;
}
