package com.ebike.openservices.oprmgmt.entity.po;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 电动汽车充电站计费方案车辆列表
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/16
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OperEvChargingStationBillingEvcarList implements Serializable {

    private static final long serialVersionUID = 2308385182264709334L;

    /**
     * 主键标识;SnowflakeId
     */
    private Long id;

    /**
     * 车辆VIN码
     */
    private String evcarVinCode;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;

    /**
     * 设置默认字段
     *
     * @return
     */
    public OperEvChargingStationBillingEvcarList defaultField() {
        this.sortSn = 1;
        this.gmtCreate = System.currentTimeMillis();
        this.modifier = "";
        this.gmtModified = 0L;
        this.isDeleted = 0;
        this.deleter = "";
        this.gmtDeleted = 0L;
        this.version = 1;
        return this;
    }

}
