package com.ebike.openservices.oprmgmt.entity.po;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 电动汽车充电站计费方案信息
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OperEvChargingStationBillingInfo implements Serializable {

    private static final long serialVersionUID = 5289763120381623117L;

    /**
     * 主键标识;SnowflakeId
     */
    private Long id;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 充电站标识
     */
    private Long chargingStationId;

    /**
     * 类型;1 - 默认；2 - 其他；
     */
    private Integer stationBillingType;

    /**
     * 状态;1 - 生效；2 - 新增待确认；3 - 修改待确认；4 - 终止待确认；5 - 恢复待确认；9 - 失效；
     */
    private Integer stationBillingStatus;

    /**
     * 说明
     */
    private String stationBillingDesc;

    /**
     * 计费模板标识
     */
    private Long billingTmplId;

    /**
     * 电动汽车充电站计费方案用户列表（白名单）标识
     */
    private Long stationBillingWhiteUserlistId;

    /**
     * 电动汽车充电站计费方案用户列表（黑名单）标识
     */
    private Long stationBillingBlackUserlistId;

    /**
     * 电动汽车充电站计费方案车辆列表（白名单）标识
     */
    private Long stationBillingWhiteEvcarlistId;

    /**
     * 电动汽车充电站计费方案车辆列表（黑名单）标识
     */
    private Long stationBillingBlackEvcarlistId;

    /**
     * 更改后计费模板标识
     */
    private Long newBillingTmplId;

    /**
     * 更改后电动汽车充电站计费方案用户列表（白名单）标识
     */
    private Long newStationBillingWhiteUserlistId;

    /**
     * 更改后电动汽车充电站计费方案用户列表（黑名单）标识
     */
    private Long newStationBillingBlackUserlistId;

    /**
     * 更改后电动汽车充电站计费方案车辆列表（白名单）标识
     */
    private Long newStationBillingWhiteEvcarlistId;

    /**
     * 更改后电动汽车充电站计费方案车辆列表（黑名单）标识
     */
    private Long newStationBillingBlackEvcarlistId;

    /**
     * 生效时间
     */
    private Date effTime;

    /**
     * 失效时间
     */
    private Date invalidTime;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;

    /**
     * 设置默认字段
     *
     * @return
     */
    public OperEvChargingStationBillingInfo defaultField() {
        this.sortSn = 1;
        this.gmtCreate = System.currentTimeMillis();
        this.modifier = "";
        this.gmtModified = 0L;
        this.isDeleted = 0;
        this.deleter = "";
        this.gmtDeleted = 0L;
        this.version = 1;
        return this;
    }

}
