package com.ebike.openservices.oprmgmt.entity.po;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.beanutils.ConvertUtils;

import java.io.Serializable;

/**
 * 电动汽车充电站计费方案操作日志
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/16
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OperEvChargingStationBillingInfoLog implements Serializable {

    private static final long serialVersionUID = -6673831096340457961L;

    /**
     * 主键标识;SnowflakeId
     */
    private Long id;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 充电站计费方案标识
     */
    private Long stationBillingInfoId;

    /**
     * 日志类型;10 – 新增；
     11 – 同意新增生效；
     12 – 不同意新增生效；
     20 – 修改；
     21 – 同意修改生效；
     22 – 不同意修改生效；
     30 – 终止；
     31 – 同意终止失效；
     32 – 不同意终止失效；
     40 – 恢复；
     41 – 同意恢复生效；
     42 – 不同意恢复生效；
     */
    private Integer logType;

    /**
     * 日志内容
     */
    private String logValue;

    /**
     * 状态;1 - 生效；2 - 新增待确认；3 - 修改待确认；4 - 终止待确认；5 - 恢复待确认；9 - 失效；
     */
    private Integer stationBillingStatus;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;

    /**
     * 设置默认字段
     *
     * @return
     */
    public OperEvChargingStationBillingInfoLog defaultField() {
        this.sortSn = 1;
        this.gmtCreate = System.currentTimeMillis();
        this.isDeleted = 0;
        this.deleter = "";
        this.gmtDeleted = 0L;
        this.version = 1;
        return this;
    }

}
