package com.ebike.openservices.oprmgmt.entity.po;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 电动汽车充电站计费方案待确认信息（利益相关方）
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/16
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OperEvChargingStationBillingInfoTbc implements Serializable {

    private static final long serialVersionUID = -6573067679935845725L;

    /**
     * 主键标识;SnowflakeId
     */
    private Long id;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 充电站计费方案标识
     */
    private Long stationBillingInfoId;

    /**
     * 利益相关方单位编号
     */
    private String stakeholderOrgNo;

    /**
     * 确认状态;0 - 待确认；1 - 确认通过；2 - 确认不通过；
     */
    private Integer confirmStatus;

    /**
     * 确认人
     */
    private String confirmer;

    /**
     * 确认时间
     */
    private Date confirmTime;

    /**
     * 确认说明
     */
    private String confirmDesc;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;

    /**
     * 设置默认字段
     *
     * @return
     */
    public OperEvChargingStationBillingInfoTbc defaultField() {
        this.sortSn = 1;
        this.gmtCreate = System.currentTimeMillis();
        this.modifier = "";
        this.gmtModified = 0L;
        this.isDeleted = 0;
        this.deleter = "";
        this.gmtDeleted = 0L;
        this.version = 1;
        return this;
    }

}
