package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @param
 * @ClassName CardAuditVo
 * @Description TODO  充电卡审核实体
 * @Author zhouyi
 * @Data 2021/7/14 15:53
 * @Version 1.0
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Builder
public class CardAuditVo implements Serializable {

    private static final long serialVersionUID = -1445885638175342069L;

    /**
     * 主键标识;SnowflakeId
     */
    private Long id;
    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /***
     * 申请时间
     */
    private String createTime;

    /***
     * 运营商名称
     */
    private String orgName;

    /***
     * 售后服务电话
     */
    private String aftersaleServiceInfo;

    /***
     * 购卡数量
     */
    private Integer purchaseApplyCardCount;

    /***
     * 工本费（单价）
     */
    private BigDecimal purchaseApplyCardCost;

    /***
     * 总费用
     */
    private BigDecimal purchaseApplyTotalMoney;


    /***
     * 寄件信息
     */
    private String deliveryInfo;

    /***
     * 审核状态;0 - 待审核；1 - 审核通过；2 - 审核退回；3 - 审核拒绝；
     */
    private Integer auditStatus;

    /***
     * 审核状态;0 - 待审核；1 - 审核通过；2 - 审核退回；3 - 审核拒绝；
     */
    private String auditStatusStr;

    /**
     * 审核说明
     */
    private String auditDesc;

    /**
     * 支付状态;0 - 待支付；1 - 支付成功；2 - 支付失败；3 - 支付取消；9 - 支付超时；
     */
    private Integer payStatus;

    /**
     * 支付状态;0 - 待支付；1 - 支付成功；2 - 支付失败；3 - 支付取消；9 - 支付超时；
     */
    private String payStatusStr;

    /**
     * 支付订单标识
     */
    private String payOrderId;

    /**
     * 支付期限;订单创建成功后，填入支付截止时间
     */
    private Date payDeadline;

    /**
     * 支付时间;支付成功时间
     */
    private Date payTime;

    /**
     * 支付备注
     */
    private String payRemark;

    /**
     * 手续费率
     */
    private BigDecimal serviceChargeRate;

    /**
     * 充电卡起始卡号
     */
    private String purchaseApplyCardNoStart;

    /**
     * 充电卡截止卡号
     */
    private String purchaseApplyCardNoEnd;

    /**
     * 充电卡背景图
     */
    private String purchaseApplyCardBgimg;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;

    /***
     * 操作
     */
    private String operation;
}
