package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @param
 * @ClassName ChargingGunInformationVo  充电枪实体
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/16 18:41
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ChargingGunInformationVo implements Serializable {

    private static final long serialVersionUID = -3345139421668067850L;

    /**
     *充电枪id
     */
    private Long id;

    /**
     *充电枪编号
     */
    private String chargingGunNo;

    /**
     *充电桩编号
     */
    private String chargingPileNo;


    /**
     *运行状态
     */
    private String runStatusStr;

    /**
     *充电电压
     */
    private BigDecimal rtEvcarOutputVoltage;

    /**
     *充电电流
     */
    private BigDecimal rtEvcarOutputCurrent;

    /**
     *充电功率
     */
    private BigDecimal rtEvcarOutputPower;

    /**
     *累计电量
     */
    private BigDecimal chargeEconsTotalHisaccum;

    /**
     *累计充电时长
     */
    private Integer chargeDurationTimesHisaccum;



}
