package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @param
 * @ClassName ChargingPileInformationVo  充电桩详情
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/16 18:35
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ChargingPileInformationVo implements Serializable {

    private static final long serialVersionUID = 2062990662431228139L;

    /**
     *充电桩id
     */
    private String id;

    /**
     *充电桩编号
     */
    private String chargingPileNo;

    /**
     *电站名称
     */
    private String chargingStationName;

    /**
     *设备厂家
     */
    private String mfrCode;

    /**
     *设备类型
     */
    private String chargingPileTypeStr;

    /**
     *工作状态
     */
    private String runStatusStr;

    /**
     *当前充电功率
     */
    private BigDecimal rtEvcarOutputPower;

    /**
     *今日充电量
     */
     private BigDecimal chargeEconsTotalToday;

    /**
     *今日充电时长
     */
    private Integer chargeDurationTimesToday;

    /**
     *今日充电次数
     */
    private Integer chargeCountToday;

    /**
     *累计充电电量
     */
     private BigDecimal chargeEconsTotalHisaccum;

    /**
     *累计充电时长
     */
    private Integer chargeDurationTimesHisaccum;

    /**
     *累计充电次数
     */
    private Integer chargeCountHisaccum;

    /**
     *累计充电收入
     */
    private BigDecimal chargeIncomeHisaccum;

    /**
     *服务器IP
     */

    /**
     *服务器端口
     */


}
