package com.ebike.openservices.oprmgmt.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @param
 * @ClassName ChargingPileVo
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/15 10:33
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ChargingPileVo implements Serializable {

    private static final long serialVersionUID = -9145965683925110374L;

    /**
     * 电桩id
     */
    private Long id;

    /**
     *电桩编号
     */
    private String chargingPileNo;

    /**
     *电桩名称
     */
    private String chargingPileName;

    /**
     *设备类型
     */
    private String  chargingPileTypeStr;

    /**
     *额定电压等级
     */
    private BigDecimal ratedInputVoltage;

    /**
     *额定功率
     */
    private BigDecimal ratedOutputCurrent;

    /**
     *电枪数
     */
    private Integer chargingGunCount;

    /**
     *运营状态  1 - 初始；2 - 待运；3 - 运行；4 - 暂停；5 - 故障；9 - 退运
     */
    private String chargingPileStatusStr;



    /**
     *操作程序版本
     */
    private String softwareVersion;


    /**
     *设备厂家
     */
    private String mfrCode;

    /**
     *装接时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String installTime;

    /**
     *投运日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String gotorunTime;

    /**
     *区分类型
     */
    private Integer type;

    /***
     * 计费方式
     */
    private String billingModelStr;

    /**
     *电枪列表
     */
    private List<ChargingGunVo> chargingGunVos;
}
