package com.ebike.openservices.oprmgmt.entity.vo;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class DetailPowerStationSafeguardChargingGunVO implements Serializable {

    private static final long serialVersionUID = -3400515004586170058L;

    /**
     * id
     */
    private Long id;

    /**
     * 充电枪编号
     */
    private String chargingGunNo;

    /**
     * 充电枪类型;1 - 快充；2 - 慢充；
     */
    private Integer chargingGunType;

    /**
     * 额定输出电流;单位：A
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal ratedOutputCurrent;

}
