package com.ebike.openservices.oprmgmt.entity.vo;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 电动汽车充电桩详情
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class DetailPowerStationSafeguardChargingPileVO implements Serializable {

    private static final long serialVersionUID = 4309330611013365143L;

    /**
     * id
     */
    private Long id;

    /**
     * 设备编号
     */
    private String chargingPileNo;

    /**
     * 设备类型;10 - 交流充电桩；21 - 直流充电桩（T）；22 - 直流充电桩（S）；
     */
    private Integer chargingPileType;

    /**
     * 额定电压;单位：V
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal ratedInputVoltage;

    /**
     * 额定功率;单位：kW
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal maxOutputPower;

}
