package com.ebike.openservices.oprmgmt.entity.vo;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 电动汽车充电站详情
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class DetailPowerStationSafeguardVO implements Serializable {

    private static final long serialVersionUID = 823026296355956979L;

    /**
     * id
     */
    private Long id;

    /**
     * 电站编号
     */
    private String chargingStationNo;

    /**
     * 电站名称
     */
    private String chargingStationName;

    /**
     * 电站状态名称
     */
    private String chargingStationStatusName;

    /**
     * 电站状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；9 - 退运；
     */
    private Integer chargingStationStatus;

    /**
     * 计费方案标识
     */
    private Long billingTmplId;

    /**
     * 计费模板名称
     */
    private String tmplName;

    /**
     * 电站类型;1 - 公共；2 - 个人；11 - 公交（专用）；12 - 环卫（专用）；13 - 物流（专用）；14 - 出租车（专用）；99 - 其他；
     */
    private Integer chargingStationType;

    /**
     * 充电总容量;单位：kVA
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal totalDistCapacity;

    /**
     * 场站负责人
     */
    private String contacter;

    /**
     * 手机号码
     */
    private String contactMobile;

    /**
     * 营业开始时间; 00:00
     */
    private String businessHoursStart;

    /**
     * 营业结束时间
     */
    private String businessHoursEnd;

    /**
     * 停车收费
     */
    private String parkingFeeDesc;

    /**
     * 预约充电; true - 支持; false - 不支持
     */
    private Boolean isSupportAppt;

    /**
     * 充电站地址
     */
    private String chargingStationAddr;

    /**
     * 行政区划代码
     */
    private String adcode;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 纬度
     */
    private BigDecimal latitude;

    /***
     * 预约时间
     */
    private String appTime;
    /***
     * 预约次数
     */
    private String appCount;
    /***
     * 预约周期
     */
    private String period;


}
