package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 首页运营概况--地图中电站详情信息已经列表信息
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-08-03
 */
@Data
public class EbikeMainChargingPileInfoVo implements Serializable {
    /**
     * 充电桩编号
     */
    private String chargingPileNo;

    /**
     * 充电桩标识
     */
    private String chargingPileId;

    /**
     * 充电桩名称
     */
    private String chargingPileName;

    /**
     * 计费参数
     */
    private String billingParams;

    /**
     * 服务费
     */
    private String priceService;

    /**
     * 自定义时间段详情
     */
    List<String> timeList;

    /**
     * 自定义时段的电价
     */
    private List<BigDecimal> priceRateList;

    /**
     * 充电站地址
     */
    private String chargingStationAddr;

    /**
     * 收费标准（1：单一电价，2：时段电价，3：自定义分时）
     */
    private String priceRateType;
    private Integer priceRateTypeNo;

    /**
     * 充电枪状态（1 - 初始；2 - 待运；3 - 运行；4 - 暂停；5 - 故障；9 - 退运；）
     */
    private String chargingGunStatus;

    /**
     * 充电进度
     */
    private BigDecimal chargeSchedule;

    /**
     * 充电开始时SOC
     */
    private BigDecimal chargeStartEvcarSoc;

    /**
     * 剩余充电时长
     */
    private String chargeRemainTimes;

    /**
     * 充电时长
     */
    private String chargTimes;

    /**
     * 充电时间
     */
    private String chargeTime;


}
