package com.ebike.openservices.oprmgmt.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 充电站计费方案操作日志列表
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/17
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class ListChargingStationBillingInfoLogVO implements Serializable {

    private static final long serialVersionUID = 7795061426869464428L;

    /**
     * id
     */
    private Long id;

    /**
     * 创建时间;为0表示为空
     */
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private String gmtCreateName;

    /**
     * 日志类型;10 – 新增；
         11 – 同意新增生效；
         12 – 不同意新增生效；
         20 – 修改；
         21 – 同意修改生效；
         22 – 不同意修改生效；
         30 – 终止；
         31 – 同意终止失效；
         32 – 不同意终止失效；
         40 – 恢复；
         41 – 同意恢复生效；
         42 – 不同意恢复生效；
     */
    private String logTypeName;

    /**
     * 操作人
     */
    private String userName;

    /**
     * 所属单位
     */
    private String userOrgName;
}
