package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 收益分享充电站列表响应参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/15
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ListEarningsShareChargeStationVO implements Serializable {

    private static final long serialVersionUID = 8701448082587931372L;

    /**
     * id
     */
    private Long id;

    /**
     * 充电站名称
     */
    private String chargingStationName;

    /**
     * 充电站地址
     */
    private String chargingStationAddr;

    /**
     * 充电站状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；9 - 退运；
     */
    private String chargingStationStatusName;

    /**
     * 充电站类型;1 - 公共；2 - 个人；11 - 公交（专用）；12 - 环卫（专用）；13 - 物流（专用）；14 - 出租车（专用）；99 - 其他；
     */
    private String chargingStationTypeName;

    /**
     * 电桩编号（多）
     */
    private List<String> chargingPileNos;
}
