package com.ebike.openservices.oprmgmt.entity.vo;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/13
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ListPowerStationSafeguardChargingGunVO implements Serializable {

    private static final long serialVersionUID = 4529601099855252148L;

    /**
     * id
     */
    private Long id;

    /**
     * 充电枪编号
     */
    private String chargingGunNo;

    /**
     * 额定输出电流;单位：A
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal ratedOutputCurrent;

    /**
     * 充电枪类型;1 - 快充；2 - 慢充；
     */
    private String chargingGunTypeName;

    /**
     * 充电枪状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；5 - 故障；9 - 退运；
     */
    private String chargingGunStatusName;

}
