package com.ebike.openservices.oprmgmt.entity.vo;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/13
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ListPowerStationSafeguardChargingPileVO implements Serializable {

    private static final long serialVersionUID = 5379926908097171545L;

    /**
     * id
     */
    private Long id;

    /**
     * 充电桩编号
     */
    private String chargingPileNo;

    /**
     * 充电桩类型;10 - 交流充电桩；21 - 直流充电桩（T）；22 - 直流充电桩（S）；
     */
    private String chargingPileTypeName;

    /**
     * 额定电压;单位：V
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal ratedInputVoltage;

    /**
     * 额定功率;单位：kW
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal maxOutputPower;

    /**
     * 充电桩状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；5 - 故障；9 - 退运；
     */
    private String chargingPileStatusName;

    /**
     * 充电枪列表
     */
    List<ListPowerStationSafeguardChargingGunVO> guns;

}
