package com.ebike.openservices.oprmgmt.entity.vo;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/13
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ListPowerStationSafeguardVO implements Serializable {

    private static final long serialVersionUID = -6914468515442562986L;

    /**
     * id
     */
    private Long id;

    /**
     * 充电站编号
     */
    private String chargingStationNo;

    /**
     * 充电站名称
     */
    private String chargingStationName;

    /**
     * 充电站地址
     */
    private String chargingStationAddr;

    /**
     * 充电站状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；9 - 退运；
     */
    private String chargingStationStatusName;

    /**
     * 充电站类型;1 - 公共；2 - 个人；11 - 公交（专用）；12 - 环卫（专用）；13 - 物流（专用）；14 - 出租车（专用）；99 - 其他；
     */
    private String chargingStationTypeName;

    /**
     * 总充电功率;单位：kW
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal maxOutputPower;

    /**
     * 配电容量;单位：kVA
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal totalDistCapacity;

    /**
     * 是否支持预约充电
     */
    private String isSupportApptName;

    /**
     * 停车收费单价;
     */
    private String parkingFeeDesc;

    /**
     * 营业时间
     */
    private String businessHours;

    /**
     * 模板名称
     */
    private String tmplName;

    /**
     * 联系人
     */
    private String contacter;

    /**
     * 手机号码
     */
    private String contactMobile;

    /**
     * 充电桩列表
     */
    List<ListPowerStationSafeguardChargingPileVO> piles;

}
