package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * 自营充电站列表下的计费模板列表
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/15
 */
@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ListSelfSupportChargeStationBillingInfoVO implements Serializable {

    private static final long serialVersionUID = 4877030720290771695L;

    /**
     * 计费方案id
     */
    private Long id;

    /**
     * 充电站标识
     */
    private Long chargingStationId;

    /**
     * 计费模板id
     */
    private Long billingTmplId;

    /**
     * 模板名称
     */
    private String tmplName;

    /**
     * 计费详情
     */
    private String billingDetail;

    /**
     * 计费模式;1 - 本地计费；2 - 主站计费；
     */
    private String billingModelName;

    /**
     * 计费类型
     */
    private String priceRateTypeName;

    /**
     * 抄表间隔;单位：分钟
     */
    private Integer billingInterval;

    /**
     * 状态;1 - 生效；2 - 新增待确认；3 - 修改待确认；4 - 终止待确认；5 - 恢复待确认；9 - 失效；
     */
    private Integer stationBillingStatus;

    /**
     * 状态名称
     */
    private String stationBillingStatusName;

    /**
     * 类型; 1 - 默认；2 - 其他；
     */
    private Integer stationBillingType;

    /**
     * 电站名称
     */
    private String chargingStationName;

    /**
     * 电站地址
     */
    private String chargingStationAddr;

    /**
     * 计费说明
     */
    private String stationBillingDesc;

}
