package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @param
 * @ClassName PowerStationEssentialInformationVo   充电站统一视图——基本信息
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/16 11:16
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PowerStationEssentialInformationVo implements Serializable {

    private static final long serialVersionUID = 5886038057031708170L;

    /**
     *主键id
     */
    private Long id;


    /**
     *电站编号
     */
    private String chargingStationNo;


    /**
     *电站名称
     */
    private String chargingStationName;

    /**
     *电站地址
     */
    private String chargingStationAddr;

    /**
     *电站类型
     */
    private String chargingStationTypeStr;

    /**
     *充电总容量
     */
    private BigDecimal totalDistCapacity;

    /**
     *预约充电  1——支持   0——不支持
     */
    private String isSupportApptStr;

    /**
     *停车收费
     */
    private BigDecimal parkingUnitPrice;

    /**
     *营业时间
     */
    private String businessTime;


    /**
     *创建日期
     */
    private String gmtCreate;


}
