package com.ebike.openservices.oprmgmt.entity.vo;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 导出（自定义时段）
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/5
 */
@Data
@SuperBuilder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class PowerStationExportCustomVo implements Serializable {

    private static final long serialVersionUID = -66060841869029609L;

    /**
     * 电站名称
     */
    private String chargingStationName;

    /**
     * 计费类型
     */
    private String billingType;

    /**
     * 总电量
     */
    private BigDecimal chargeEconsTotal;

    /**
     * 电价
     */
    private BigDecimal priceTotal;

    /**
     * 服务费
     */
    private BigDecimal chargeExpenseService;

    /**
     * 总费用
     */
    private BigDecimal closingMoney;
}
