package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 导出（免费）
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/5
 */
@Data
@SuperBuilder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class PowerStationExportFreeVo implements Serializable {

    private static final long serialVersionUID = -5146051211278502085L;

    /**
     * 电站名称
     */
    private String chargingStationName;

    /**
     * 计费类型
     */
    private String billingType;

    /**
     * 尖电量
     */
    private BigDecimal chargeEconsRate1;

    /**
     * 峰电量
     */
    private BigDecimal chargeEconsRate2;

    /**
     * 平电量
     */
    private BigDecimal chargeEconsRate3;

    /**
     * 谷电量
     */
    private BigDecimal chargeEconsRate4;

    /**
     * 总电量
     */
    private BigDecimal chargeEconsTotal;
}
