package com.ebike.openservices.oprmgmt.entity.vo;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 导出（时段）
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/5
 */
@Data
@SuperBuilder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class PowerStationExportMultiVo implements Serializable {

    private static final long serialVersionUID = 6167472604327458946L;

    /**
     * 电站名称
     */
    private String chargingStationName;

    /**
     * 计费类型
     */
    private String billingType;

    /**
     * 尖电量
     */
    private BigDecimal chargeEconsRate1;

    /**
     * 峰电量
     */
    private BigDecimal chargeEconsRate2;

    /**
     * 平电量
     */
    private BigDecimal chargeEconsRate3;

    /**
     * 谷电量
     */
    private BigDecimal chargeEconsRate4;

    /**
     * 总电量
     */
    private BigDecimal chargeEconsTotal;

    /**
     * 尖电费
     */
    private BigDecimal chargeExpenseRate1;

    /**
     * 峰电费
     */
    private BigDecimal chargeExpenseRate2;

    /**
     * 平电费
     */
    private BigDecimal chargeExpenseRate3;

    /**
     * 谷电费
     */
    private BigDecimal chargeExpenseRate4;

    /**
     * 总电费
     */
    private BigDecimal chargeExpenseTotal;

    /**
     * 服务费
     */
    private BigDecimal chargeExpenseService;

    /**
     * 总费用
     */
    private BigDecimal closingMoney;
}
