package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 导出（单一）
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/5
 */
@Data
@SuperBuilder
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class PowerStationExportSingleVo implements Serializable {

    private static final long serialVersionUID = 1504259140622958374L;

    /**
     * 电站名称
     */
    private String chargingStationName;

    /**
     * 计费类型
     */
    private String billingType;

    /**
     * 总电量
     */
    private BigDecimal chargeEconsTotal;

    /**
     * 总电费
     */
    private BigDecimal chargeExpenseTotal;
}
