package com.ebike.openservices.oprmgmt.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * @param
 * @ClassName PowerStationVo
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/15 10:35
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PowerStationVo implements Serializable {

    private static final long serialVersionUID = -7956617314641928959L;
    /**
     *电站id
     */
    private Long id;

    /**
     *电站编号
     */
     private String chargingStationNo;

     /**
     *电站名称
     */
     private String chargingStationName;

    /**
     *电站地址
     */
    private String chargingStationAddr;

    /**
     *电站状态   1 - 初始；2 - 待运；3 - 运行；4 - 暂停；9 - 退运
     */
    private String chargingStationStatusStr;

    /**
     *电桩数量
     */
    private Integer chargingNum;

    /**
     *电站类型   1 - 公共；2 - 个人；11 - 公交（专用）；12 - 环卫（专用）；13 - 物流（专用）；14 - 出租车（专用）；99 - 其他
     */
     private String chargingStationTypeStr;

    /**
     *电价类型  单一电价——single   时段电价——multi
     */
    private String priceRateType;

    /**
     *单一电价值
     */
    private String priceTotal;

    /**
     *时段电价值
     */
    private String priceService;

    /**
     *计费方式  1 - 本地计费；2 - 主站计费
     */
    private String billingModelStr;

    /**
     *服务费率
     */
     private Double serviceRate;

    /**
     *收益分享人
     */
    private String earningsName;

    /**
     *投运日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
     private String gotorunDate;

    /**
     *所属运营商
     */
     private String orgoprName;

     /**
     *电站联系人
     */
    private String contacter;

    /**
     *联系电话
     */
    private String contactPhone;

    /**
     *区分类型
     */
    private Integer type;

    /**
     *充电桩列表
     */
    private List<ChargingPileVo> chargingPileVos;





}
