package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @param
 * @ClassName RechargeCardVo
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/7/15 15:11
 * @Version 1.0
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@Builder
public class RechargeCardVo implements Serializable {

    private static final long serialVersionUID = -3406394573461762920L;

    /***
     * card_custom_purchase_apply 表主键   运营商定制充电卡申请标识
     */
    private Long id;
    /***
     *充电卡卡号
     */
    private String cardId;

    /***
     *所属运营商
     */
    private String orgName;

    /***
     *手机号
     */
    private String orgNo;


    /***
     *充电卡状态 0:初始化1绑定2解绑3挂失（绑定才能挂失）
     */
    private Integer status;

    /***
     *充电卡状态 0:初始化1绑定2解绑3挂失（绑定才能挂失）
     */
    private String statusStr;

    /***
     *充电卡类型
     */
    private Integer cardType;

    /***
     *充电卡类型
     */
    private String cardTypeStr;


    /***
     *绑定日期
     */
    private String bindTime;

    /***
     *余额
     */
    private BigDecimal accountBalance;

    /***
     *充电卡总余额
     */
    private BigDecimal totalAccountBalance;

    /***
     *充电卡总充值
     */
    private BigDecimal totalInAmount;

   /***
    *申请充电卡张数
    */
    private Integer purchaseApplyCardCount;
    /***
     *联系电话
     */
    private String phoneNo;

    /***
     *工本费单价
     */
    private BigDecimal purchaseApplyCardCost;
    /***
     *总价
     */
    private BigDecimal purchaseApplyTotalMoney;
    /***
     *批次
     */
    private String batch;

    /***
     * 寄件地址
     */
    private String deliveryInfo;
}
