package com.ebike.openservices.oprmgmt.entity.vo;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 上传模板文件，判断用户、车辆是否存在重复
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/21
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
public class UploadTemplateFileVO implements Serializable {

    private static final long serialVersionUID = 8813826448872411036L;

    /**
     * 文件名称
     */
    private String filename;

    /**
     * 唯一手机号
     */
    private List<String> uniquenessPhone;

    /**
     * 重复手机号
     */
    private List<String> repetitionPhone;

    /**
     * 唯一vin码
     */
    private List<String> uniquenessVin;

    /**
     * 重复vin码
     */
    private List<String> repetitionVin;
}
