package com.ebike.openservices.oprmgmt.enums;

/**
 * 失败状态码
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/21
 */
public enum ErrorCodeEnum implements ICode {

    ERROR(400, "请求失败"),

    /**
     * 400001 - 该计费模板在本站已经存在，请重新添加
     */
    BILLING_SCHEME_ID_ERROR(400001, "该计费模板在本站已经存在，请重新添加"),

    /**
     * 400002 - 电站下存在充电桩不可删除
     */
    POWER_STATION_CHARGING_PILE_ERROR(400002, "电站下存在充电桩不可删除"),

    /**
     * 400003 - 电站下存在充电枪不可删除
     */
    POWER_STATION_CHARGING_GUN_ERROR(400003, "电站下存在充电枪不可删除"),

    /**
     * 400006 - 该计费模板被充电站关联，不允许编辑和删除
     */
    CHARGING_STATION_ASSOCIATION_ERROR(400006, "该计费模板被充电站关联，不允许编辑和删除"),

    /**
     * 400007
     */
    BILLING_SCHEME_FORMAT_USER_ERROR(400007, "上传适用用户手机号格式错误，请删除后重新上传"),

    /**
     * 400008
     */
    BILLING_SCHEME_FORMAT_CAR_ERROR(400008, "上传适用车辆文件格式错误，请删除后重新上传"),

    ;

    private int code;
    private String msg;

    ErrorCodeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }
}
