package com.ebike.openservices.oprmgmt.enums;

/**
 * 成功状态码
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/21
 */
public enum SuccessCodeEnum implements ICode {

    /**
     * 200 - 请求成功
     */
    SUCCESS(200, "请求成功"),

    /**
     * 200001 - 计费模板设置成功,即时生效
     */
    BILLING_SCHEME_ID_SUCCESS(200001, "计费模板设置成功,即时生效"),

    /**
     * 200002 - 计费模板新增操作成功，请等待共享人确认
     */
    BILLING_SCHEME_ADD_SHARE_SUCCESS(200002, "计费模板新增操作成功，请等待共享人确认"),

    ;

    private int code;
    private String msg;

    SuccessCodeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public int getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }
}
