package com.ebike.openservices.oprmgmt.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 充电趋势分析（电动汽车）
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-08-03
 */
@Data
public class ChargingTrendAnalysisCarRequest implements Serializable {

    /**
     * 运营商编号
     */
    private String orgNo;
    /**
     * 起始日期
     */
    private String startTime;
    /**
     * 截止日期
     */
    private String endTime;
    /**
     * 日期
     */
    private String dateStat;

    /**
     * 日期类型（自定义：0，月：1，年：2）
     */
    private String dateType;

    /**
     * 电站id
     */
    private String chargingStationId;

    /**
     * 区域编码
     */
    private String adcode;
}
