package com.ebike.openservices.oprmgmt.request;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 新增计费方案参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/15
 */
@Data
@Accessors(chain = true)
public class InsertBillingSchemeParam implements Serializable {

    private static final long serialVersionUID = 3740340640145881654L;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 充电站标识
     */
    private Long chargingStationId;

    /**
     * 计费模板标识
     */
    private Long billingTmplId;

    /**
     * 说明
     */
    private String stationBillingDesc;

    /**
     * 重复用户
     */
    private List<String> repetitionUsers;

    /**
     * 唯一用户
     */
    private List<String> uniquenessUser;

    /**
     * 重复车辆
     */
    private List<String> repetitionCars;

    /**
     * 唯一车辆
     */
    private List<String> uniquenessCars;

    /**
     * 1 - 沿用 ; 2 - 更新
     */
    private Integer updateOrInsert;

}
