package com.ebike.openservices.oprmgmt.request;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
@Data
@Accessors(chain = true)
public class InsertPowerStationParam implements Serializable {

    private static final long serialVersionUID = -2897930863842523745L;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 电站编号
     */
    private String chargingStationNo;

    /**
     * 电站名称
     */
    private String chargingStationName;

    /**
     * 电站状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；9 - 退运；
     */
    private Integer chargingStationStatus;

    /**
     * 计费方案标识
     */
    private Long billingTmplId;

    /**
     * 电站类型;1 - 公共；2 - 个人；11 - 公交（专用）；12 - 环卫（专用）；13 - 物流（专用）；14 - 出租车（专用）；99 - 其他；
     */
    private Integer chargingStationType;

    /**
     * 充电总容量;单位：kVA
     */
    private BigDecimal totalDistCapacity;

    /**
     * 场站负责人
     */
    private String contacter;

    /**
     * 手机号码
     */
    private String contactMobile;

    /**
     * 营业开始时间; 00:00
     */
    private String businessHoursStart;

    /**
     * 营业结束时间; 00:00
     */
    private String businessHoursEnd;

    /**
     * 停车收费
     */
    private String parkingFeeDesc;

    /**
     * 预约充电; true - 支持; false - 不支持
     */
    private Boolean isSupportAppt;

    /**
     * 预约信息
     */
    private String  appInfo;

    /**
     * 充电站地址
     */
    private String chargingStationAddr;

    /**
     * 行政区划代码
     */
    private String adcode;

    /**
     * 经度
     */
    private BigDecimal longitude;

    /**
     * 纬度
     */
    private BigDecimal latitude;

}
