package com.ebike.openservices.oprmgmt.request;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 电站维护列表参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/13
 */
@Data
@Accessors(chain = true)
public class ListPowerStationSafeguardParam implements Serializable {

    private static final long serialVersionUID = 9165638737492479374L;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 电站id
     */
    private Long id;

    /**
     * 充电站编号
     */
    private String chargingStationNo;

    /**
     * 充电站名称
     */
    private String chargingStationName;

    /**
     * 充电站状态;1 - 初始；2 - 待运；3 - 运行；4 - 暂停；9 - 退运；
     */
    private Integer chargingStationStatus;

    /**
     * 充电桩编号
     */
    private String chargingPileNo;

    /**
     * 充电枪编号
     */
    private String chargingGunNo;

    /**
     * 模板名称
     */
    private String tmplName;

    /**
     * 充电站类型;1 - 公共；2 - 个人；11 - 公交（专用）；12 - 环卫（专用）；13 - 物流（专用）；14 - 出租车（专用）；99 - 其他；
     */
    private Integer chargingStationType;

}
