package com.ebike.openservices.oprmgmt.request;

import lombok.Data;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 电量电费导出
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/4
 */
@Data
public class PowerChargeExportRequest implements Serializable {

    private static final long serialVersionUID = 7725876540478325761L;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 电站名称（模糊搜索）
     */
    private String chargingStationName;

    /**
     * 计费模式：1 - 免费模式；2 - 单一电价；3 - 时段电价；4 - 自定义时段电价
     */
    private Integer billingType = 1;

    /**
     * 时间维度：1 - 日；2 - 月；3 - 年
     */
    private Integer dateType = 3;

    /**
     * 日期：日 - yyyy-MM-dd；月 - yyyy-MM；年 - yyyy
     */
    private String date = new SimpleDateFormat("yyyy").format(new Date());
}
