package com.ebike.openservices.oprmgmt.request;

import com.easesource.data.bean.Pager;
import lombok.Data;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 电量电费列表参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/3
 */
@Data
public class PowerChargeListParam extends Pager {

    private static final long serialVersionUID = 2154622975120578968L;

    /**
     * 单位编号
     */
    private String orgNo;

    /**
     * 电站名称（模糊搜索）
     */
    private String chargingStationName;

    /**
     * 计费模式：1 - 免费模式；2 - 单一电价；3 - 时段电价；4 - 自定义时段电价
     */
    private Integer billingType = 1;

    /**
     * 时间维度：1 - 日；2 - 月；3 - 年；4 - 自定义
     */
    private Integer dateType = 3;

    /**
     * 开始日期：日： yyyy-MM-dd；月： yyyy-MM；年： yyyy
     */
    private String date = new SimpleDateFormat("yyyy").format(new Date());

    /**
     * 截止日期；日：yyyy-MM-dd
     */
    private String endDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
}
