package com.ebike.openservices.oprmgmt.request;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

/**
 * @param
 * @ClassName PowerStationRequestParam
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/15 15:50
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class PowerStationRequestParam {

    /**
     * 事业单位编号
     */
    private String orgNo;

    /**
     * 电站名称
     */
    private String chargingStationName;


    /**
     * 电站地址
     */
    private String chargingStationAddr;


    /**
     * 电桩编号
     */
    private String chargingPileNo;

    /**
     * 电站状态   1 - 初始；2 - 待运；3 - 运行；4 - 暂停；9 - 退运；
     */
    private Integer chargingStationStatus;


    /**
     * 所属运营商
     */
    private String orgName;

    /**
     * 当前页
     */
    private Integer current;

    /**
     * 页数据条数
     */
    private Integer pageSize;


}
