package com.ebike.openservices.oprmgmt.request;

import lombok.Data;

/**
 * 充电汽车项目-->计费模板维护
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-04-13
 */
@Data
public class TmplBillingRequest {
    /**
     * 主键标识;SnowflakeId
     */
    private Long id;

    /**
     * 一级业务单位编号;系统单位表（sys_org）中单位类型org_type为2 – 业务单位级，最高级业务单位（即一级运营商）的单位编号
     */
    private String primaryOrgNo;

    /**
     * 业务单位编号
     */
    private String orgNo;

    /**
     * 模板编号
     */
    private String tmplNo;

    /**
     * 模板名称
     */
    private String tmplName;

    /**
     * 模板说明
     */
    private String tmplDesc;

    /**
     * 计费分类;1 - 电动自行车充电计费模板；2 - 电动汽车充电计费模板；
     */
    private Integer billingClass;

    /**
     * 计费小类;1 - 计时间；2 - 计电量；3 - 计次（按时间）；4 - 计次（按电量）；
     */
    private Integer billingSubclass;

    /**
     * 计费参数;// 当计费分类为2电动汽车充电计费模板；计费小类为2计电量时：
     * // 单费率（ 单一电价）
     * {"price_rate_type": "single", "price_total": 1.0}
     * // 复费率（ 时段电价）rate_count 表示费率数，rate_period_type 表示费率时段类型（1 - 设备费率时段；2 - 主站费率时段），price_service 表示服务费，单位 元 / kWh
     * //// 复费率 & 设备费率时段
     * {"price_rate_type": "multi", "rate_count": 4, "rate_period_type": 1, "price_rate01": 1.0, "price_rate02": 2.0, "price_rate03": 3.0, "price_rate04": 4.0, "price_service": 1.0}
     * //// 复费率 & 主站费率时段
     * {"price_rate_type": "multi", "rate_count": 4, "rate_period_type": 2, "start_value_rate_period01": "00:00", "number_rate_period01": 4, "start_value_rate_period02": "08:00", "number_rate_period02": 1, "start_value_rate_period03": "12:00", "number_rate_period03": 2, "start_value_rate_period04": "13:00", "number_rate_period04": 3, "start_value_rate_period05": "18:00", "number_rate_period05": 1, "start_value_rate_period06": "20:00", "number_rate_period06": 2, "start_value_rate_period06": "23:00", "number_rate_period06": 4, "price_rate01": 1.0, "price_rate02": 2.0, "price_rate03": 3.0, "price_rate04": 4.0, "price_service": 1.0}
     */
    private String billingParams;

    /**
     * 计费模式;1 - 本地计费；2 - 主站计费；
     */
    private Integer billingModel;

    /**
     * 计费间隔;单位：分钟
     */
    private Integer billingInterval;

    /**
     * 排序序号
     */
    private Integer sortSn;

    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;

    /**
     * 创建时间;为0表示为空
     */
    private Long gmtCreate;

    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * 更新时间;为0表示为空
     */
    private Long gmtModified;

    /**
     * 是否已删除;逻辑删除（1 - 已删除；0 - 未删除；）
     */
    private Integer isDeleted;

    /**
     * 删除人;系统用户表用户编号字段（user_no）
     */
    private String deleter;

    /**
     * 删除时间;为0表示为空
     */
    private Long gmtDeleted;

    /**
     * 版本号;用于乐观锁
     */
    private Integer version;

    /**
     * 新增：1；修改：2；
     */
    private Integer type;

    /**
     * 时段电价（复费率）
     */
    private String priceRate01;
    private String priceRate02;
    private String priceRate03;
    private String priceRate04;
    private String priceRate05;
    private String priceRate06;
    private String priceRate07;
    private String priceRate08;
    private String priceRate09;
    private String priceRate10;

    /**
     * 电度电价主站分时（十个时间段）
     */
    private String startValueRatePeriod01;
    private String startValueRatePeriod02;
    private String startValueRatePeriod03;
    private String startValueRatePeriod04;
    private String startValueRatePeriod05;
    private String startValueRatePeriod06;
    private String startValueRatePeriod07;
    private String startValueRatePeriod08;
    private String startValueRatePeriod09;
    private String startValueRatePeriod10;

    /**
     * 电度电价主站分时（电价）
     */
    private String numberRatePeriod01;
    private String numberRatePeriod02;
    private String numberRatePeriod03;
    private String numberRatePeriod04;
    private String numberRatePeriod05;
    private String numberRatePeriod06;
    private String numberRatePeriod07;
    private String numberRatePeriod08;
    private String numberRatePeriod09;
    private String numberRatePeriod10;

    /**
     * 单费率（ 单一电价）
     */
    private String priceTotal;

    /**
     * 费率类型（single，deviceMulti，multi）
     */
    private String priceRateType;

    /**
     * 费率数
     */
    private Integer rateCount;

    /**
     * 服务费
     */
    private String priceService;

    /**
     * 费率时段类型（1 - 设备费率时段；2 - 主站费率时段）
     */
    private String ratePeriodType;

    private int current;
    /***
     * 模板类型  1 自行车  2汽车
     */
    private int timplType;

}
