package com.ebike.openservices.oprmgmt.request;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 修改计费模板
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/17
 */
@Data
@Accessors(chain = true)
public class UpdateBillingSchemeParam implements Serializable {

    private static final long serialVersionUID = -8231931024827640352L;

    /**
     * id
     */
    private Long id;

    /**
     * 修改人;系统用户表用户编号字段（user_no）
     */
    private String modifier;

    /**
     * org_no
     */
    private String orgNo;

    /**
     * 充电站标识
     */
    private Long chargingStationId;

    /**
     * 计费模板标识
     */
    private Long billingTmplId;

    /**
     * 说明
     */
    private String stationBillingDesc;

    /**
     * 重复用户
     */
    private List<String> repetitionUsers;

    /**
     * 唯一用户
     */
    private List<String> uniquenessUsers;

    /**
     * 重复车辆
     */
    private List<String> repetitionCars;

    /**
     * 唯一车辆
     */
    private List<String> uniquenessCars;

    /**
     * 1 - 更新 ; 2 - 沿用
     */
    private Integer updateOrInsert;
}
