package com.ebike.openservices.oprmgmt.request;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 编辑设备参数
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
@Data
@Accessors(chain = true)
public class UpdateChargingPileParam implements Serializable {

    private static final long serialVersionUID = -8799116793540582653L;

    /**
     * id
     */
    private Long id;

    /**
     * 设备编号
     */
    private String chargingPileNo;

    /**
     * 设备类型;10 - 交流充电桩；21 - 直流充电桩（T）；22 - 直流充电桩（S）；
     */
    private Integer chargingPileType;

    /**
     * 额定电压;单位：V
     */
    private BigDecimal ratedInputVoltage;

    /**
     * 额定功率;单位：kW
     */
    private BigDecimal maxOutputPower;

}
