package com.ebike.openservices.oprmgmt.response;

import com.ebike.openservices.oprmgmt.dto.Decimal2Serializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 电量电费
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/4
 */
@Data
public class PowerChargeResponse implements Serializable {

    private static final long serialVersionUID = 8927217329031867888L;

    /**
     * 电站id
     */
    private Long stationId;

    /**
     * 电站名称
     */
    private String chargingStationName;

    /**
     * 计费类型
     */
    private String billingType;

    /**
     * 尖电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeEconsRate1;

    /**
     * 峰电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeEconsRate2;

    /**
     * 平电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeEconsRate3;

    /**
     * 谷电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeEconsRate4;

    /**
     * 总电量
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeEconsTotal;

    /**
     * 尖电费
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeExpenseRate1;

    /**
     * 峰电费
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeExpenseRate2;

    /**
     * 平电费
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeExpenseRate3;

    /**
     * 谷电费
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeExpenseRate4;

    /**
     * 总电费
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeExpenseTotal;

    /**
     * 服务费
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal chargeExpenseService;

    /**
     * 总费用
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal closingMoney;

    /**
     * 电价
     */
    @JsonSerialize(using = Decimal2Serializer.class)
    private BigDecimal priceTotal;

    /**
     * 计费参数
     */
    private String billingParams;

    /**
     * 自定义时间段详情
     */
    List<String> timeList;

    /**
     * 自定义时段电量详情
     */
    private List<BigDecimal> econsDetailList;

    /**
     * 自定义时段电价详情
     */
    private List<BigDecimal> priceDetailList;
}
