package com.ebike.openservices.oprmgmt.service;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.dto.PageResponse;
import com.ebike.openservices.oprmgmt.entity.vo.*;
import com.ebike.openservices.oprmgmt.request.*;

import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/15
 */
public interface BillingSchemeSettingService {

    /**
     * 自营充电站列表
     *
     * @param param
     * @param pager
     * @return
     */
    PageResponse<ListSelfSupportChargeStationVO> listSelfSupportChargeStation(ListSelfSupportChargeStationParam param, Pager pager);

    /**
     * 收益分享充电站列表
     *
     * @param param
     * @param pager
     * @return
     */
    PageResponse<ListEarningsShareChargeStationVO> listEarningsShareChargeStation(ListEarningsShareChargeStationParam param, Pager pager);

    /**
     * 上传模板文件，判断用户、车辆是否存在重复
     *
     * @param param
     * @return
     */
    UploadTemplateFileVO uploadTemplateFile(UploadTemplateFileParam param);

    /**
     * 添加计费方案
     *
     * @param param
     * @return
     */
    void insertBillingScheme(InsertBillingSchemeParam param);

    /**
     * 修改计费方案
     *
     * @param param
     * @return
     */
    void updateBillingScheme(UpdateBillingSchemeParam param);

    /**
     * 终止计费方案
     *
     * @param id
     * @param orgNo
     * @param userNo
     * @return
     */
    int stopBillingScheme(Long id, String orgNo, String userNo);

    /**
     * 电站下计费方案列表
     *
     * @param chargingStationId
     * @return
     */
    List<ListSelfSupportChargeStationBillingInfoVO> listSelfSupportChargeStationBillingInfo(Long chargingStationId);

    /**
     * 计费方案的适用用户列表
     *
     * @param id
     * @param pager
     * @return
     */
    PageResponse listChargingStationBillingUser(Long id, Pager pager);

    /**
     * 计费方案修改之后的适用用户列表
     *
     * @param id
     * @param pager
     * @return
     */
    PageResponse listChargingStationBillingUserAfter(Long id, Pager pager);

    /**
     * 计费方案的适用车辆列表
     *
     * @param id
     * @param pager
     * @return
     */
    PageResponse listChargingStationBillingCar(Long id, Pager pager);

    /**
     * 计费方案的适用车辆列表（修改之后）
     *
     * @param id
     * @param pager
     * @return
     */
    PageResponse listChargingStationBillingCarAfter(Long id, Pager pager);

    /**
     * 充电站计费方案操作日志列表
     *
     * @param stationBillingInfoId
     * @param pager
     * @return
     */
    PageResponse<ListChargingStationBillingInfoLogVO> listChargingStationBillingInfoLog(Long stationBillingInfoId, Pager pager);

    /**
     * 收益分享人操作是否同意计费方案
     *
     * @param param
     */
    void isAgreeBillingScheme(IsAgreeBillingSchemeParam param);

    /**
     * 解禁计费方案
     *
     * @param id
     * @param orgNo
     * @param userNo
     * @return
     */
    int liftABanBillingScheme(Long id, String orgNo, String userNo);

}
