package com.ebike.openservices.oprmgmt.service;

import com.ebike.openservices.oprmgmt.entity.CarRegisterExamineVo;
import com.ebike.openservices.oprmgmt.entity.OpenIdVo;

import java.util.List;

/**
 * @author liumu
 * @date 2021/4/16 16:23
 */
public interface CarRegisterCheckService {

    /**
     * 根据用户手机号码获取openid
     * @param phone         手机号码
     * @return              List<String>
     */
    List<OpenIdVo> queryOpenidByPhone(String phone);


//    /**
//     * 审核
//     * @param bean
//     */
//    void examineRegister(CarRegisterExamineVo bean);

    /**
     * 通过openId获取openId对应名称
     *
     * @param openId
     * @return
     */
    String queryOpenIdNameByOpenId(String openId);

    /**
     * 更新档案openId
     * @param id            记录id(subburo)
     * @param isWx          是否是微信特约商户：Y-是；N-否
     * @param openId        openId
     * @param openIdName    openId对应名称
     */
    void updateOpenId(String id,String isWx,String openId,String openIdName);
}
